<!--
Template Name: Listar Informativos
-->
<?php get_header(); ?> <!-- Mostrar o cabealho -->
	
<!--
*********************************************************
*              Inicio do Contedo principal             *
*********************************************************
-->	
<div id="conteudo" class="row">


<!--
*********************************************************
*                   Contedo Principal                  *
*********************************************************
-->	
	<div id="noticia_progepe" class="small-12 medium-12 large-12 columns centered">

	   <h2> Informativos </h2>
	<?php wp_reset_query();  ?>

<?php 
	
	$paged = get_query_var('paged') ? get_query_var('paged') : 1;

	$args = array(
		'post_type'			=> 'informativos',
		'posts_per_page' 	=> 3,
		'order' 			=> 'DESC',
		'orderby'  			=> 'date',
		'paged' 			=> $paged
    );
	
	$consulta = new WP_Query( $args );
	
 	while ($consulta->have_posts()) : $consulta->the_post(); ?>


        <!-- Coloca o ttulo do informativo -->
		<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3> 
		
		<!-- Coloca o resumo do informativo -->
		<div style="margin-left:0.3em;">
			<?php the_excerpt(); ?>
		</div>
        
		<button class="veja_mais">
			<a href="<?php the_permalink() ?>">Leia mais... </a>
		</button>
		
		<hr>
	<?php endwhile; ?>

<!--
*********************************************************
*                  Plugin WP_PAGENAVI                   *
*   Mostra a paginao se este plugin estiver ativado   *
*********************************************************
-->	
 		<?php if(function_exists('wp_pagenavi')) { wp_pagenavi(array('query'=> $consulta));} ?>

</div>

	
 </div> <!-- fechamento da div conteudo -->
<?php get_footer(); ?> <!-- Mostrar o rodap -->