<!--
Template Name: Listar Eventos
-->
<?php get_header(); ?> <!-- Mostrar o cabealho -->
	
<!--
*********************************************************
*              Inicio do Contedo principal             *
*********************************************************
-->	
<div id="conteudo" class="row">


<!--
*********************************************************
*                   Contedo Principal                  *
*********************************************************
-->	
	<div id="noticia_progepe" class="small-12 medium-12 large-12 columns centered">

	   <h2> Eventos </h2>
	<?php wp_reset_query();  ?>

<?php 
	
	$paged = get_query_var('paged') ? get_query_var('paged') : 1;

	$args = array(
		'post_type'			=> 'eventos',
		'posts_per_page' 	=> 3,
		'order' 			=> 'DESC',
		'orderby'  			=> 'data_do_evento',
		'meta_key'			=> 'data_do_evento',
		'paged' 			=> $paged
    );
	
	$consulta = new WP_Query( $args );
	
 	while ($consulta->have_posts()) : $consulta->the_post(); ?>


        <!-- Coloca o ttulo do evento -->
			<h3><a href="<?php the_permalink() ?>"><?php the_title(); ?></a></h3> 
		
		<!--
		***************************************************************
		* Campos Personalizados - Plugin Advanced Custom Fields (ACF) *
		***************************************************************
		-->
			
			<div style="margin-left:0.3em; margin-top:-1em; font-size:0.7em; color:#666; font-style:italic;">
				<!-- Coloca a data do evento -->
				<i class="icon_calendar"> </i> <strong> Data:  <?php the_field('data_do_evento'); ?> </strong>
																	
				<!-- Coloca o horrio do evento -->
				<!-- <i class="icon_clock"> </i> <strong> Hora: </strong> --> <?php // the_field('horario_do_evento'); ?> 
				<i class="icon_clock_alt"> </i> <strong> Hora:  <?php the_field('horario_do_evento'); ?> </strong>
								 
				<!-- Coloca o local do evento -->
				<!--<i class="icon_pin"> </i> <strong> Local: </strong> --> <?php // the_field('local_do_evento'); ?>
				<!-- <i class="icon_pin_alt"> </i> <strong> Local: </strong> --> <?php // the_field('local_do_evento'); ?>
			</div>
			
			<!-- Coloca o resumo do evento -->
			<div style="margin-left:0.3em;">
				<?php the_excerpt(); ?>
			</div>
        
		<button class="veja_mais">
			<a href="<?php the_permalink() ?>">Leia mais... </a>
		</button>
		
		<hr>
	<?php endwhile; ?>

<!--
*********************************************************
*                  Plugin WP_PAGENAVI                   *
*   Mostra a paginao se este plugin estiver ativado   *
*********************************************************
-->	
 		<?php if(function_exists('wp_pagenavi')) { wp_pagenavi(array('query'=> $consulta));} ?>

</div>

	
 </div> <!-- fechamento da div conteudo -->
<?php get_footer(); ?> <!-- Mostrar o rodap -->