﻿<?php
/*
Template Name: Acessibilidade
*/
?>
<?php get_header(); ?> <!-- Mostrar o cabecalho -->



<?php 

	$sitio = get_bloginfo( 'name' );  
	$titulo='<strong>Este portal da "' . $sitio . '" segue o modelo de identidade digital padr&atilde;o do governo federal, que atende &agrave;s principais recomenda&ccedil;&otilde;es de acessibilidade indicadas para web</strong><br><hr>';
	$rodape = '<div class="callout secondary">Ajude-nos a disponibilizar um site cada vez mais acess&iacute;vel.<br> Caso encontre algum problema de acessibilidade, ou tenha sugest&atilde;o de melhoria, entre em contato pelo e-mail: webdesign@ufpr.br</div>';
?>

<!-- Início conteúdo principal da página usando ZURB CSS -->

<div id="conteudo" class="row">

<!--
*********************************************************
*                        BreadCrumb                     *
*********************************************************
-->	
<div style="margin-bottom: 0.4em;" class="breadcrumbs" typeof="BreadcrumbList" vocab="https://schema.org/">
    <?php if(function_exists('bcn_display'))
    {
        bcn_display();
    }?>
</div>


<!--
*********************************************************
*            Conteúdo Principal Acessibilidade          *
*********************************************************
-->	    
    <div class="small-12 medium-12 columns">

			
			<h2>Acessibilidade</h2><!-- Mostra o título da pagina -->
			<br>
			<div> 
				<?php echo $titulo; ?>

			<!-- Mostra o conteúdo da pagina -->

				<p>O termo acessibilidade significa incluir a pessoa com deficiência na participação de atividades como o uso de produtos, serviços e informações. Alguns exemplos são os prédios com rampas de acesso para cadeira de rodas e banheiros adaptados para deficientes.
				Na internet, acessibilidade refere-se principalmente às recomendações do WCAG (World Content Accessibility Guide) do W3C e no caso do Governo Brasileiro ao e-MAG (Modelo de Acessibilidade em Governo Eletrônico). O e-MAG está alinhado as recomendações internacionais, mas estabelece padrões de comportamento acessível para sites governamentais.</p>

				<p>Na parte superior do Portal Brasil existe uma barra de acessibilidade onde se encontra atalhos de navegação padronizados e a opção para alterar o contraste. Essas ferramentas estão disponíveis em todas as páginas do portal.</p>

				<strong>Os padrões de atalhos do governo federal são:</strong>
				<ul>
					<li>
						Teclando-se Alt + 1 em qualquer página do portal, chega-se diretamente ao começo do conteúdo principal da página.
					</li>
					<li>
						Teclando-se Alt + 2 em qualquer página do portal, chega-se diretamente ao início do menu principal.
					</li>
					<li>
						Teclando-se Alt + 3 em qualquer página do portal, chega-se diretamente em sua busca interna.
					</li>
					<li>
						Teclando-se Alt + 4 em qualquer página do portal, chega-se diretamente as colunas de links e rodapé da página.
					</li>
				</ul>
				<strong>Observações: </strong>
					<p>No caso do Firefox, em vez de Alt + número, tecle simultaneamente Alt + Shift + número.<br>
						Sendo Firefox no Mac OS, em vez de Alt + Shift + número, tecle simultaneamente Ctrl + Alt + número.<br>
						No Opera, as teclas são Shift + Escape + número. Ao teclar apenas Shift + Escape, o usuário encontrará uma janela com todas as <br>
					alternativas de ACCESSKEY da página.
					</p>

					<p>Ao final desse texto, você poderá baixar alguns arquivos que explicam melhor o termo acessibilidade e como deve ser implementado nos sites da Internet.
					</p>

				<strong>Leis e decretos sobre acessibilidade:</strong>
				<ul>
					<li>
						Decreto nº 5.296 de 02 de dezembro de 2004 (<a href="http://www.planalto.gov.br/ccivil_03/_Ato2004-2006/2004/Decreto/D5296.htm">http://www.planalto.gov.br/ccivil_03/_Ato2004-2006/2004/Decreto/D5296.htm</a>).
					</li>
					<li>
						Decreto nº 6.949, de 25 de agosto de 2009 – Promulga a Convenção Internacional sobre os Direitos das Pessoas com Deficiência e seu Protocolo Facultativo, assinados em Nova York, em 30 de março de 2007 (<a href="http://www.planalto.gov.br/ccivil_03/_ato2007-2010/2009/decreto/d6949.htm">http://www.planalto.gov.br/ccivil_03/_ato2007-2010/2009/decreto/d6949.htm</a>).
					</li>
					<li>
						Decreto nº 7.724, de 16 de Maio de 2012 – Regulamenta a Lei No 12.527, que dispõe sobre o acesso a informações (<a href="http://www.planalto.gov.br/ccivil_03/_ato2011-2014/2012/Decreto/D7724.htm">http://www.planalto.gov.br/ccivil_03/_ato2011-2014/2012/Decreto/D7724.htm</a>).
					</li>
					<li>
						Modelo de Acessibilidade de Governo Eletrônico (<a href="https://www.governodigital.gov.br/documentos-e-arquivos/e-MAG%20V3.pdf">http://www.governoeletronico.gov.br/acoes-e-projetos/e-MAG</a>).
					</li>
					<li>
						Portaria nº 03, de 07 de Maio de 2007 – formato .pdf (35,5Kb) – Institucionaliza o Modelo de Acessibilidade em Governo Eletrônico – e-MAG (<a href="https://www.governodigital.gov.br/documentos-e-arquivos/legislacao/portaria3_eMAG.pdf">https://www.governodigital.gov.br/documentos-e-arquivos/legislacao/portaria3_eMAG.pdf</a>).
					</li>
				</ul>
			 
				<?php echo $rodape; ?>

			</div>
	</div> 

</div><!-- Fechamento #row #conteudo -->

<?php get_footer(); ?> <!-- Mostrar o rodape -->