<?php
/**
 * Theme Customizer WPUFPR
 */

// Funcao para customizar as Opcoes de Aparencia no painel do Customizer
function UFPRWordPress_customize_register( $wp_customize ) {


	$wp_customize->remove_control('header_textcolor');
	$wp_customize->remove_section('custom_css');
	$wp_customize->remove_section('static_front_page');


/****************************************************
	IDENTIDADE DO SITE
****************************************************/
	$wp_customize->remove_control('site_icon'); 
	$wp_customize->remove_control('blogdescription');
	$wp_customize->get_control('display_header_text')->label = __( 'Mostrar o t&iacute;tulo do site na barra de pesquisa?' );
	$wp_customize->get_setting('blogname')->transport = 'refresh';

// Secao padrao de identidade do site "title_tagline"

// Adiciona as Configuracoes (add_setting)
	$wp_customize->add_setting('wpufpr_identidade_color', array(
		'default' 	=> '#ffffff',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_identidade_color_shadow', array(
		'default' 	=> '#999999',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_identidade_checkbox_shadow', array(
		'default' 	=> '1',
		'transport' => 'refresh'
	));

// Adiciona os Controles (add_control) na secao "title_tagline"
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_identidade_color_control', array(
		'label' 	=> __('Cor do título do site na barra de pesquisa', 'UFPRWordPress'),
		'section' 	=> 'title_tagline',
		'settings' 	=> 'wpufpr_identidade_color',
		'priority'	=> 40
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_identidade_color_shadow_control', array(
		'label' 	=> __('Cor da sombra do título do site na barra de pesquisa', 'UFPRWordPress'),
		'section' 	=> 'title_tagline',
		'settings' 	=> 'wpufpr_identidade_color_shadow',
		'priority'	=> 60
	) ) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_identidade_checkbox_shadow_control', array(
		'label' 	=> __('Utilizar sombra no título do site na barra de pesquisa?', 'UFPRWordPress'),
		'section' 	=> 'title_tagline',
		'settings' 	=> 'wpufpr_identidade_checkbox_shadow',
		"type"     => "checkbox",
		'priority'	=> 50
	) ) );


/****************************************************
	MENU PRINCIPAL HORIZONTAL
****************************************************/

// Adiciona a Secao (add_section) "wpufpr_menu_principal_colors"
	$wp_customize->add_section('wpufpr_menu_principal_colors', array(
		'title' 	=> __('Menu Principal horizontal', 'UFPRWordPress'),
		'priority' 	=> 30
	));

// Adiciona as Configuracoes (add_setting)
	$wp_customize->add_setting('wpufpr_menu_principal_link_color', array(
		'default' 	=> '#ffffff',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_principal_seta_subitens_link_color', array(
		'default' 	=> '#ffffff',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_principal_bgn_color', array(
		'default' 	=> '#0d4538',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_principal_bgn_item_color', array(
		'default' 	=> '#0d4538',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_principal_bgn_hover_color', array(
		'default' 	=> '#3fa28c',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_principal_shadow_link_color', array(
		'default' 	=> '#0d4538',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_principal_checkbox_shadow', array(
		'default' 	=> '1',
		'transport' => 'refresh'
	));


// Adiciona os Controles (add_control) na secao "wpufpr_menu_principal_colors"
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_principal_link_color_control', array(
		'label' 	=> __('Cor dos links do menu', 'UFPRWordPress'),
		'section'	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_link_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_principal_seta_subitens_link_color_control', array(
		'label' 	=> __('Cor das setas indicativas de subítens do menu', 'UFPRWordPress'),
		'section'	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_seta_subitens_link_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_principal_bgn_color_control', array(
		'label' 	=> __('Cor de fundo do menu', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_bgn_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_principal_bgn_item_color_control', array(
		'label' 	=> __('Cor de fundo dos ítens de menu', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_bgn_item_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_principal_bgn_hover_color_control', array(
		'label' 	=> __('Cor de fundo dos ítens de menu ao passar o mouse', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_bgn_hover_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_principal_shadow_link_color_control', array(
		'label' 	=> __('Cor da sombra nos links do menu', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_shadow_link_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_menu_principal_checkbox_shadow_control', array(
		'label' 	=> __('Utilizar sombra nos links do menu?', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_principal_colors',
		'settings' 	=> 'wpufpr_menu_principal_checkbox_shadow',
		"type"     => "checkbox"
	) ) );


/****************************************************
	           MENU SIDEBAR VERTICAL
****************************************************/

// Adiciona a Secao (add_section) "wpufpr_menu_sidebar_colors"
	$wp_customize->add_section('wpufpr_menu_sidebar_colors', array(
		'title' 	=> __('Menu Sidebar vertical', 'UFPRWordPress'),
		'priority' 	=> 30
	));

// Adiciona as Configuracoes (add_setting)
	$wp_customize->add_setting('wpufpr_menu_sidebar_title_color', array(
		'default' 	=> '#fff',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_title_bgn_color', array(
		'default' 	=> '#000',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_shadow_title_color', array(
		'default' 	=> '#0d4538',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_checkbox_title_shadow', array(
		'default' 	=> '1',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_link_color', array(
		'default' 	=> '#ffffff',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_seta_subitens_link_color', array(
		'default' 	=> '#ffffff',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_bgn_item_color', array(
		'default' 	=> '#0d4538',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_shadow_link_color', array(
		'default' 	=> '#0d4538',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_menu_sidebar_checkbox_shadow', array(
		'default' 	=> '1',
		'transport' => 'refresh'
	));

// Adiciona os Controles (add_control) na secao "wpufpr_menu_sidebar_colors"
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_title_color', array(
		'label' 	=> __('Cor do título do menu vertical', 'UFPRWordPress'),
		'section'	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_title_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_title_bgn_color', array(
		'label' 	=> __('Cor de fundo do título do menu vertical', 'UFPRWordPress'),
		'section'	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_title_bgn_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_shadow_title_color_control', array(
		'label' 	=> __('Cor da sombra no título do menu vertical', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_shadow_title_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_menu_sidebar_checkbox_shadow_title_control', array(
		'label' 	=> __('Utilizar sombra no título do menu vertical?', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_checkbox_title_shadow',
		"type"     => "checkbox"
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_link_color_control', array(
		'label' 	=> __('Cor dos links do menu vertical', 'UFPRWordPress'),
		'section'	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_link_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_seta_subitens_link_color_control', array(
		'label' 	=> __('Cor das setas indicativas de subítens do menu', 'UFPRWordPress'),
		'section'	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_seta_subitens_link_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_bgn_item_color_control', array(
		'label' 	=> __('Cor de fundo dos ítens de menu vertical', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_bgn_item_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'wpufpr_menu_sidebar_shadow_link_color_control', array(
		'label' 	=> __('Cor da sombra nos links do menu vertical', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_shadow_link_color'
	) ) );

	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_menu_sidebar_checkbox_shadow_control', array(
		'label' 	=> __('Utilizar sombra nos links do menu vertical?', 'UFPRWordPress'),
		'section' 	=> 'wpufpr_menu_sidebar_colors',
		'settings' 	=> 'wpufpr_menu_sidebar_checkbox_shadow',
		"type"     => "checkbox"
	) ) );


/****************************************************
	COR DE FUNDO DA PAGINA
****************************************************/
	
// Pega a Secao de cores (get_section) e altera o titulo padrao
	$wp_customize->get_section('colors')->title = __( 'Cor de fundo da p&aacute;gina' );

// Adiciona as Configuracoes (add_setting)
	$wp_customize->add_setting('background_color', array(
		'default' 	=> '#ffffff',
		'transport' => 'refresh'
	));


/****************************************************
	IMAGEM DO CABECALHO
****************************************************/

	$wp_customize->get_section('header_image')->description = __( 'Atenção!! Para o tema WPUFPR o ideal é uma imagem de cabeçalho com 1200 × 250 píxeis de tamanho.' );


/****************************************************
	IMAGEM DE FUNDO
****************************************************/
	
// Adiciona as Configuracoes (add_setting)
	$wp_customize->add_setting('background_image', array(
		'default' 	=> '',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting( 'background_size', array(
		'default' => 'auto',
		'transport' => 'refresh'
	) );
	
	$wp_customize->add_setting( 'background_repeat', array(
		'default' => 'no-repeat',
		'transport' => 'refresh'
	) );
	
	$wp_customize->add_setting( 'background_position', array(
		'default' => 'center',
		'transport' => 'refresh'
	) );


/****************************************************
	ENDERECO DA UNIDADE NO RODAPE
****************************************************/

// Adiciona a Secao (add_section) "wpufpr_standard_rodape"
	$wp_customize->add_section('wpufpr_standard_rodape', array(
		'title' 	=> __('Endere&ccedil;o da unidade no rodap&eacute;', 'UFPRWordPress'),
		'priority' 	=> 90
	));

// Adiciona as Configuracoes (add_setting)
	$wp_customize->add_setting('wpufpr_rua_rodape', array(
		'default' 	=> '',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_cep_rodape', array(
		'default' 	=> '',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_fone_rodape', array(
		'default' 	=> '',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_email_rodape', array(
		'default' 	=> '',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_cidade_rodape', array(
		'default' 	=> '',
		'transport' => 'refresh'
	));

	$wp_customize->add_setting('wpufpr_uf_rodape', array(
		'default' 	=> 'PR',
		'transport' => 'refresh'
	));


// Adiciona os Controles (add_control) na secao "wpufpr_standard_rodape"
	$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_rua_rodape_control', array(
		'label' 	=> __('Local / Rua', 'UFPRWordPress'),
		'section'	=> 'wpufpr_standard_rodape',
		'settings' 	=> 'wpufpr_rua_rodape',
		"type"     => "text"
	)	) );

	
		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_cep_rodape_control', array(
		'label' 	=> __('CEP', 'UFPRWordPress'),
		'section'	=> 'wpufpr_standard_rodape',
		'settings' 	=> 'wpufpr_cep_rodape',
		"type"     => "text"
	)	) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_fone_rodape_control', array(
		'label' 	=> __('Telefone', 'UFPRWordPress'),
		'section'	=> 'wpufpr_standard_rodape',
		'settings' 	=> 'wpufpr_fone_rodape',
		"type"     => "text"
	)	) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_email_rodape_control', array(
		'label' 	=> __('Email', 'UFPRWordPress'),
		'section'	=> 'wpufpr_standard_rodape',
		'settings' 	=> 'wpufpr_email_rodape',
		"type"     => "text"
	)	) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_cidade_rodape_control', array(
		'label' 	=> __('Cidade', 'UFPRWordPress'),
		'section'	=> 'wpufpr_standard_rodape',
		'settings' 	=> 'wpufpr_cidade_rodape',
		"type"     => "text"
	)	) );

		$wp_customize->add_control( new WP_Customize_Control( $wp_customize, 'wpufpr_uf_rodape_control', array(
		'label' 	=> __('Estado', 'UFPRWordPress'),
		'section'	=> 'wpufpr_standard_rodape',
		'settings' 	=> 'wpufpr_uf_rodape',
		"type"     => "text"
	)	) );

}


add_action('customize_register', 'UFPRWordPress_customize_register');


// Funcao para Customizacao do CSS pelo painel do Customizer
function UFPRWordPress_customize_css() { ?>

	<style type="text/css">

	/* Alterar as cores no nome do site na barra de pesquisa */
		.barra_pesquisa h3{
			color: <?php echo get_theme_mod('wpufpr_identidade_color'); ?>!important;
					<?php if( get_theme_mod('wpufpr_identidade_checkbox_shadow', 1 ) == '1' ) { ?>
			text-shadow: 1px 1px 0 <?php echo get_theme_mod('wpufpr_identidade_color_shadow');} else{ ?>;
			text-shadow: none; <?php } ?>
		}

	/* Alterar as cores do menu principal horizontal */
		#menu_principal{
			font-family: "Open Sans", sans-serif !important;
			font-weight: normal !important;
		}
		#menu_principal div{
			background-color: <?php echo get_theme_mod('wpufpr_menu_principal_bgn_color'); ?>;
		}
		#menu_principal .menu{
			background-color: <?php echo get_theme_mod('wpufpr_menu_principal_bgn_color'); ?>;
		}
		#menu_principal .menu li{
			background-color: <?php echo get_theme_mod('wpufpr_menu_principal_bgn_item_color'); ?>;
		}
		#menu_principal .menu li a{
			color: <?php echo get_theme_mod('wpufpr_menu_principal_link_color'); ?>!important;
					<?php if( get_theme_mod('wpufpr_menu_principal_checkbox_shadow', 1 ) == '1' ) { ?>
			text-shadow: 1px 1px 0 <?php echo get_theme_mod('wpufpr_menu_principal_shadow_link_color');} else{ ?>;
			text-shadow: none; <?php } ?>
		}

    	/* define a cor da seta que indica presença de sub-itens de menu */
		.dropdown.menu > li.is-dropdown-submenu-parent > a::after{
    		border-color: <?php echo get_theme_mod('wpufpr_menu_principal_seta_subitens_link_color'); ?> transparent transparent;
		}
		#menu_principal .menu li:hover{
			background-color: <?php echo get_theme_mod('wpufpr_menu_principal_bgn_hover_color'); ?>;
		}

	/* Alterar as cores do menu sidebar vertical */
		#sidebar_progepe h5, 
		#sidebar_ccat h5,
		#sidebar_caiss h5,
		#sidebar_cdp h5,
		#sidebar_cpp h5,
		#sidebar_dap h5
		{
			background-color: <?php echo get_theme_mod('wpufpr_menu_sidebar_title_bgn_color'); ?>;	
			color: <?php echo get_theme_mod('wpufpr_menu_sidebar_title_color'); ?>;	
			border-top: 3px solid <?php echo get_theme_mod('wpufpr_menu_sidebar_title_color'); ?>;	
 			<?php if( get_theme_mod('wpufpr_menu_sidebar_checkbox_title_shadow', 1 ) == '1' ) { ?>
			text-shadow: 1px 1px 0 <?php echo get_theme_mod('wpufpr_menu_sidebar_shadow_title_color');} else{ ?>;
			text-shadow: none; <?php } ?>		
		}
		#sidebar_progepe ul.nested ul li a, 
		#sidebar_ccat ul.nested ul li a,
		#sidebar_caiss ul.nested ul li a,
		#sidebar_cdp ul.nested ul li a,
		#sidebar_cpp ul.nested ul li a,
		#sidebar_dap ul.nested ul li a
		{
			background-color: <?php echo get_theme_mod('wpufpr_menu_sidebar_bgn_item_color'); ?>;
		}
		#sidebar_progepe ul li a::after,
		#sidebar_ccat ul li a::after,
		#sidebar_caiss ul li a::after,
		#sidebar_cdp ul li a::after,
		#sidebar_cpp ul li a::after,
		#sidebar_dap ul li a::after
		{
			border-color: <?php echo get_theme_mod('wpufpr_menu_sidebar_title_color'); ?> transparent transparent !important;
		}

		#sidebar_progepe ul.nested ul li a:before, 
		#sidebar_ccat ul.nested ul li a:before,
		#sidebar_caiss ul.nested ul li a:before,
		#sidebar_cdp ul.nested ul li a:before,
		#sidebar_cpp ul.nested ul li a:before,
		#sidebar_dap ul.nested ul li a:before
		{
			color: <?php echo get_theme_mod('wpufpr_menu_sidebar_seta_subitens_link_color'); ?>;
		}
		#sidebar_progepe ul.nested ul li a, 
		#sidebar_ccat ul.nested ul li a,
		#sidebar_caiss ul.nested ul li a,
		#sidebar_cdp ul.nested ul li a,
		#sidebar_cpp ul.nested ul li a,
		#sidebar_dap ul.nested ul li a
		{
			color: <?php echo get_theme_mod('wpufpr_menu_sidebar_link_color'); ?>!important;
					<?php if( get_theme_mod('wpufpr_menu_sidebar_checkbox_shadow', 1 ) == '1' ) { ?>
			text-shadow: 1px 1px 0 <?php echo get_theme_mod('wpufpr_menu_sidebar_shadow_link_color');} else{ ?>;
			text-shadow: none; <?php } ?>
		}
		#sidebar_progepe ul.nested ul li:last-child, 
		#sidebar_ccat ul.nested ul li:last-child,
		#sidebar_caiss ul.nested ul li:last-child,
		#sidebar_cdp ul.nested ul li:last-child,
		#sidebar_cpp ul.nested ul li:last-child,
		#sidebar_dap ul.nested ul li:last-child
		{
			border-bottom: 3px solid <?php echo get_theme_mod('wpufpr_menu_sidebar_bgn_item_color'); ?> ;
		}
		#sidebar_progepe ul.nested ul li ul li:last-child, 
		#sidebar_ccat ul.nested ul li ul li:last-child,
		#sidebar_caiss ul.nested ul li ul li:last-child,
		#sidebar_cdp ul.nested ul li ul li:last-child,
		#sidebar_cpp ul.nested ul li ul li:last-child,
		#sidebar_dap ul.nested ul li ul li:last-child		
		{
			border-bottom: none;
		}
		#sidebar_progepe ul li a:first-child, 
		#sidebar_ccat ul li a:first-child,
		#sidebar_caiss ul li a:first-child,
		#sidebar_cdp ul li a:first-child,
		#sidebar_cpp ul li a:first-child,
		#sidebar_dap ul li a:first-child
		{
			background-color: <?php echo get_theme_mod('wpufpr_menu_sidebar_title_bgn_color'); ?>;
			color: <?php echo get_theme_mod('wpufpr_menu_sidebar_title_color'); ?>!important;
					<?php if( get_theme_mod('wpufpr_menu_sidebar_checkbox_title_shadow', 1 ) == '1' ) { ?>
			text-shadow: 1px 1px 0 <?php echo get_theme_mod('wpufpr_menu_sidebar_shadow_title_color');} else{ ?>;
			text-shadow: none; <?php } ?>
		}
	</style>

<?php }

		add_action('wp_head', 'UFPRWordPress_customize_css');

?>